clear all

load ./mat_files/TD_to_fracking.mat

O_share = TD_.theta_o(1:end-1).*TD_.F_o(1:end-1)./TD_.o(2:end);
NO_share = TD_.theta_n(1:end-1).*TD_.F_n(1:end-1)./TD_.o(2:end);

O_share     = [endo_0.theta_o*endo_0.F_o/TD_.o(1); O_share];
NO_share     = [endo_0.theta_n*endo_0.F_n/TD_.o(1); NO_share];

O_share_data = [0.426977, 0.4344299, 0.4224814, 0.4141974, 0.4198925, 0.4315602, ...
    0.4266561, 0.4170849, 0.3965102];
NO_share_data = [0.556015, 0.5375278, 0.5361108, 0.5307045, 0.5188427, 0.5106318, ...
    0.5072678, 0.4974777, 0.4992879];

time = 2011:2050;
x_ind = 1:40;
lw = 6;
fs = 24;

hfig = figure('color', 'w');
pos     = get(hfig,'position');
set(hfig,'position',pos.*[.5 1 2 2])

subplot(2, 2, 2), hold on
plot(time, ((TD_.p(x_ind))./(endo_0.p)-1)*100, 'linewidth', lw)
plot(time([1 end]), ones(1, 2)* ((endo_T.p)/(endo_0.p)-1)*100, 'linewidth', lw, 'linestyle', '--', 'color', [0.8500, 0.3250, 0.0980]	)
set(gca, 'fontsize', fs, 'fontweight', 'bold', 'fontname', 'palatino')
title('Oil prices')
ylabel('Difference (%)')
grid on

subplot(2, 2, 1); hold on
plot(time, ((TD_.o(x_ind))./(endo_0.o)-1)*100, 'linewidth', lw)
plot(time([1 end]), ones(1, 2)* ((endo_T.o)/(endo_0.o)-1)*100, 'linewidth', lw, 'linestyle', '--', 'color', [0.8500, 0.3250, 0.0980]	)
set(gca, 'fontsize', fs, 'fontweight', 'bold', 'fontname', 'palatino')
title('Oil production')
ylabel('Difference (%)')
grid on

subplot(2, 2, 3); hold on
plot(time, ((TD_.y(x_ind))./(endo_0.Y)-1)*100, 'linewidth', lw)
plot(time([1 end]), ones(1, 2)* ((endo_T.Y)/(endo_0.Y)-1)*100, 'linewidth', lw, 'linestyle', '--', 'color', [0.8500, 0.3250, 0.0980]	)
set(gca, 'fontsize', fs, 'fontweight', 'bold', 'fontname', 'palatino')
title('World GDP')
ylabel('Difference (%)')
grid on

subplot(2, 2, 4); hold on
plot(time, 100*NO_share(x_ind), 'linewidth', lw, 'color', [0.9290, 0.6940, 0.1250])
plot(time, 100* O_share(x_ind), 'linewidth', lw, 'color', [0.4940, 0.1840, 0.5560])
plot(time, 100* (1-O_share(x_ind)-NO_share(x_ind)), 'linewidth', lw, 'color', [0.4660, 0.6740, 0.1880])
ylim([0 80])
set(gca, 'fontsize', fs, 'fontweight', 'bold', 'fontname', 'palatino')
legend('Non-OPEC conv.', 'OPEC', 'Non-OPEC fracking')
title('Oil market shares')
ylabel('Market share (%)')
grid on

print('../../Figures/Figure_7','-dpng')
